## Регистрация пользователей

Контроллер Register позволяет регистрировать пользователей в заданные группы и отправлять уведомления о регистрации. Контроллер является расширением контроллера Form, соответственно можно использовать соответствующие параметры для отправки писем при регистрации.

Имена полей в форме должны соответствовать полям модели [modUsers](http://docs.evolution-cms.com/Extras/Snippets/DocLister/MODxAPI).

Если в форме не задано поле username, то ему присваивается значение поля email. Таким образом можно регистрировать пользователей только по email.

Если в форме не задано поле password, то значение поля генерируется автоматически. То есть регистрацию пользователя можно свести к указанию email.

При регистрации с паролем, в форме может присутствовать поле repeatPassword. Если заданы правила валидации для полей password и repeatPassword, то при наличии для поля repeatPassword правила equals, оно будет автоматически скорректировано для проверки равенства значений полей password и repeatPassword:
```
"repeatPassword":{
    "required":"Введите пароль еще раз",
    "equals":{
        "params" : "Этот ключ в описании правила можно не задавать, он будет сформирован контроллером автоматически",
        "message":"Пароли не совпадают"
    }
}
```

При регистрации следует проверять уникальность имени пользователя и email. В контроллере предусмотрены соответствующие правила:
```
&rules=`{
    "username":{
        "required":"Введите имя пользователя",
        "alphaNumeric":"Только буквы и цифры",
        "custom":{
            "function":"\\FormLister\\Register::uniqueUsername",
            "message":"Имя уже занято"
        }
    },
    "email":{
        "required":"Введите email",
        "email":"Неверный email",
        "custom":{
            "function":"\\FormLister\\Register::uniqueEmail",
            "message":"Этот email уже использует другой пользователь"
        }
    }
}`
```
В шаблонах доступны все поля модели для созданной записи. Дополнительно задается поле user.password с незашифрованным паролем. 

## Параметры
### model
Класс для работы с пользователями.

Возможные значения - имя класса.

Значение по умолчанию - \modUsers

### modelPath
Путь к файлу класса для работы с пользователями.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modUsers.php

### allowedFields
Разрешенные для обработки поля. Поля, не указанные в списке, игнорируются. Поля username, email и password всегда разрешены.

Если не задано, то разрешены все поля.

Возможные значения - имена полей формы, разделенные запятой. 

Значение по умолчанию - пусто.

### forbiddenFields
Запрещенные для обработки поля. Поля, указанные в списке, игнорируются. Поля username, email и password удаляются из списка запрещенных.

Возможные значения - имена полей формы, разделенные запятой. 

Значение по умолчанию - пусто.

### userGroups
Добавляет зарегистрированного пользователя в указанные группы.

Возможные значения - имена групп, разделенные запятой (если имена содержат запятую в названии, то можно задать значение параметра массивом).

Значение по умолчанию - пусто.

### checkActivation
Включает проверку активации учетной записи пользователя (см. "Активация учетных записей"). При этом после сохранения записи будет установлено поле activate.url, содержащее ссылку на страницу с вызовом сниппета для активации учетной записи.  

Возможные значения - 1 или 0.

Значение по умолчанию - 0.

### activateTo
Если включена проверка активации, то в этом параметре необходимо указать id страницы, на которой вызывается сниппет для активации.

Возможные значения - id страницы.

Значение по умолчанию - значение $modx->config['site_start'].

### preparePostProcess
Позволяет выполнить обработку данных после сохранения.

Возможные значения - имена сниппетов, анонимные функции, статические методы загруженных классов.

Значение по умолчанию - пусто.

### redirectTo
Перенаправляет пользователя на указанную страницу после регистрации.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### exitTo
Перенаправляет уже авторизованного пользователя на указанную страницу.

Возможные значения - id целевой страницы.

Значение по умолчанию - пусто.

### skipTpl
Шаблон сообщения для уже авторизованного пользователя.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Register с ключом [+register.default_skipTpl+]

### successTpl
Шаблон сообщения об успешной регистрации. 

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Register с ключом [+register.default_successTpl+]

### passwordLength
Длина пароля (если создается автоматически).

Возможные значения - число символов больше 6.

Значение по умолчанию - 6.
